IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_LGPD_PROCESSAMENTO_FORN')
BEGIN 
	DROP PROCEDURE P_LGPD_PROCESSAMENTO_FORN
END 

GO 
/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 21100101
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_FORN 
'Objetivo............: Procedure responsavel pela anonimização de Fornecedores - LGPD 
'Tabelas.............: PG_FORN, LGPD_LOG_PROCESSAMENTO
'Dt Criação..........: 
'Dt Ult Alteracão....: 01/10/2021
'Alterado por........: Marcos barros
'Criado por..........: Rayane
'=======================================================================================
Reg #21081901 - Alteração retorno RAISERROR  - Marcos Barros
Reg #21081901 - Alteração estrutura de insert em @NAO_ANONIMIZAR_DADOS - Marcos Barros
Reg #21100101 - Alteração tipo de dados retornado por parametro - Marcos Barros
*/

CREATE PROCEDURE P_LGPD_PROCESSAMENTO_FORN (@CD_FORN INT )
WITH ENCRYPTION
AS  
	SET NOCOUNT ON 
	
	DECLARE @NAO_ANONIMIZAR_DADOS TABLE  (CD_FORN INT, DESCRICAO VARCHAR(1000) );
	 
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_DEB.CD_CLI, 
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) +', COM VINCULO COM CLIENTE COM TÍTULOS EM ABERTO - DEB') AS DESCRICAO
    FROM RC_DEB RC_DEB
		JOIN RC_CLI ON RC_DEB.CD_EMP = RC_CLI.CD_EMP
			AND RC_DEB.CD_CLI = RC_CLI.CD_CLI 
			JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
	WHERE RC_DEB.CD_EMP  = 1 
	   AND RC_DEB.STS_DP  IN (0,2,5)
	   AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN 
	   AND RC_CLI.PESSOA  = 0 
	 
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT  
		EST_PED_VD.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) +', COM VINCULO COM CLIENTE COM ORÇAMENTO/TELE VENDAS/PRÉ FATURA EM ABERTO') AS DESCRICAO
	FROM EST_PED_VD
		JOIN RC_CLI ON EST_PED_VD.CD_EMP = RC_CLI.CD_EMP 
			AND EST_PED_VD.CD_CLI = RC_CLI.CD_CLI 
		JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
	WHERE EST_PED_VD.CD_EMP = 1 
		AND EST_PED_VD.STS_PED =0
		AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN 
		AND RC_CLI.PESSOA = 0 
	 
	INSERT INTO @NAO_ANONIMIZAR_DADOS 
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) +', COM VINCULO COM CLIENTE QUE REALIZARAM PAGAMENTO COM CHEQUE E ESTÁ EM ABERTO - CHEQUE') AS DESCRICAO
	FROM PDV_VD
		JOIN PDV_VD_CHQS ON PDV_VD.CD_EMP    = PDV_VD_CHQS.CD_EMP   
			AND PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
			AND PDV_VD.CD_VD     = PDV_VD_CHQS.CD_VD  
		JOIN PDV_VD_CHQS_CHQ_LANC ON PDV_VD_CHQS.CD_EMP    = PDV_VD_CHQS_CHQ_LANC.CD_EMP   						
 			AND PDV_VD_CHQS.CD_FILIAL = PDV_VD_CHQS_CHQ_LANC.CD_FILIAL
		 	AND PDV_VD_CHQS.CD_VD     = PDV_VD_CHQS_CHQ_LANC.CD_VD  
			AND PDV_VD_CHQS.NR_ORD    = PDV_VD_CHQS_CHQ_LANC.NR_ORD  
		JOIN CHQ_LANC_CPL ON CHQ_LANC_CPL.CD_EMP = PDV_VD_CHQS_CHQ_LANC.CD_EMP
			AND CHQ_LANC_CPL.CD_CHQ = PDV_VD_CHQS_CHQ_LANC.CD_CHQ
		JOIN RC_CLI ON RC_CLI.CD_EMP = PDV_VD.CD_EMP
			AND RC_CLI.CD_CLI = PDV_VD.CD_CLI 
		JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
    WHERE PDV_VD.CD_EMP = 1  
		AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN 
		AND RC_CLI.PESSOA =  0
		AND CHQ_LANC_CPL.STS_CHQ IN (0,1,2,5,6,7,9)
	   
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) +', COM VINCULO COM CLIENTE COM TÍTULOS EM ABERTO - CONVENIADO') AS DESCRICAO
	FROM RC_CLI_CONV_RC_CLI 
		JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
			AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
		JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
	WHERE RC_CLI.CD_EMP = 1 
		AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN 
	    AND RC_CLI_CONV_RC_CLI.VLR_DEB > 0
	    AND RC_CLI.PESSOA =  0

	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) +', COM VINCULO COM CLIENTE COM ORÇAMENTO/TELE VENDAS/PRÉ FATURA EM ABERTO/CHEQUE') AS DESCRICAO
	FROM RC_CLI_CREDIARIO 
		JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
			AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
		JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
	WHERE RC_CLI.CD_EMP = 1 
		AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN
		AND RC_CLI_CREDIARIO.VLR_DEB_CRED > 0
	    AND RC_CLI.PESSOA =  0
	   
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT  
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: FORNECEDOR - '+ CAST(@CD_FORN AS VARCHAR) + ', COM TÍTULOS EM ABERTO - NOTA SAIDA') AS DESCRICAO
	FROM EST_NF_SAI 
		JOIN RC_CLI ON EST_NF_SAI.CD_CLI = RC_CLI.CD_CLI
		JOIN PG_FORN_RC_CLI ON RC_CLI.CD_CLI  = PG_FORN_RC_CLI.CD_CLI 
	WHERE EST_NF_SAI.STS_NF= 0 
		AND RC_CLI.PESSOA = 0 
		AND PG_FORN_RC_CLI.CD_FORN  = @CD_FORN
		AND NOT EXISTS (SELECT CD_CTR_ARQ 
						  FROM EST_NF_SAI_ARQ_DANFE 
						 WHERE EST_NF_SAI_ARQ_DANFE.CD_EMP    = EST_NF_SAI.CD_EMP 
						   AND EST_NF_SAI_ARQ_DANFE.CD_FILIAL = EST_NF_SAI.CD_FILIAL 
						   AND EST_NF_SAI_ARQ_DANFE.CD_NF     = EST_NF_SAI.CD_NF)
	
	IF EXISTS (SELECT 1 FROM @NAO_ANONIMIZAR_DADOS WHERE CD_FORN = @CD_FORN )
	BEGIN
		DECLARE @ERRORMESSAGE VARCHAR(MAX)= (SELECT DESCRICAO FROM ( SELECT T.DESCRICAO, ROW_NUMBER() OVER(ORDER BY CD_FORN DESC) AS RowNumber FROM @NAO_ANONIMIZAR_DADOS T WHERE CD_FORN = @CD_FORN ) AS tmp WHERE RowNumber = 1);
		RAISERROR (@ERRORMESSAGE, 16, 1);
		RETURN;
	END
	
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: 
   ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/	
  
	UPDATE PG_FORN 
	SET	 RZ_FORN     ='ANONIMIZADO'
		,NM_FANT	 ='ANONIMIZADO'
		,CGC_CPF 	 ='000000000000'	
		,END_FORN	 ='ANONIMIZADO'
		,TEL		 ='0000000000'
		,FAX		 ='0000000000'
		,CONTATO	 ='0000000000'
		,EMAIL    	 ='ANONIMIZADO@ANONIMIZADO'
	FROM PG_FORN
	WHERE PG_FORN.CD_EMP = 1
		AND PG_FORN.CD_FORN = @CD_FORN
		AND PG_FORN.PESSOA = 0  

	INSERT INTO LGPD_LOG_PROCESSAMENTO  (CD_PESSOA,DT_CAD,NM_FM,TP_PROC)
	SELECT @CD_FORN						AS CD_CLI, 
		   GETDATE()					AS DT_CAD,
		   'P_LGPD_PROCESSAMENTO_FORN'	AS NM_FM,
		   2							AS TP_PROC 